# utils.py
import hashlib

# --------- Gestion des mots de passe ---------
def hash_password(password: str) -> str:
    """Retourne le hash SHA256 d'un mot de passe."""
    return hashlib.sha256(password.encode('utf-8')).hexdigest()

def verify_password(password: str, hashed: str) -> bool:
    """Vérifie qu'un mot de passe correspond à son hash."""
    return hash_password(password) == hashed
