# check_dbs.py
import os, sqlite3, sys

BASE_DIR = os.getcwd()
DB_DIR = os.path.join(BASE_DIR, "database")
db_files = {
    "students": os.path.join(DB_DIR, "students.db"),
    "users": os.path.join(DB_DIR, "users.db"),
    "access": os.path.join(DB_DIR, "access.db"),
    "families": os.path.join(DB_DIR, "families.db"),
    "nutrition": os.path.join(DB_DIR, "nutrition.db"),
}

def print_schema(path):
    print(f"\n--- {os.path.basename(path)} ---")
    if not os.path.exists(path):
        print("-> Fichier absent.")
        return
    try:
        conn = sqlite3.connect(path)
        c = conn.cursor()
        # tables
        c.execute("SELECT name FROM sqlite_master WHERE type='table'")
        tables = [r[0] for r in c.fetchall()]
        print("Tables:", tables)
        # pragma table_info pour chaque table
        for t in tables:
            c.execute(f"PRAGMA table_info({t})")
            cols = c.fetchall()
            print(f"  Table `{t}` columns:")
            for col in cols:
                print("   ", col)
        conn.close()
    except sqlite3.DatabaseError as e:
        print("-> ERREUR SQLITE:", e)

def ensure_students_statut(path):
    if not os.path.exists(path):
        print("students.db absent, je ne peux pas ajouter de colonne.")
        return
    try:
        conn = sqlite3.connect(path)
        c = conn.cursor()
        c.execute("PRAGMA table_info(students)")
        columns = [r[1] for r in c.fetchall()]
        if "statut" not in columns:
            print("Ajout de la colonne 'statut' à students...")
            c.execute("ALTER TABLE students ADD COLUMN statut TEXT DEFAULT 'actif'")
            conn.commit()
            print("-> Colonne 'statut' ajoutée.")
        else:
            print("-> Colonne 'statut' existe déjà.")
        conn.close()
    except sqlite3.DatabaseError as e:
        print("-> ERREUR SQLITE (students):", e)

if __name__ == "__main__":
    print("Dossier DB:", DB_DIR)
    for k,p in db_files.items():
        print_schema(p)

    # exemple de réparation : ajouter 'statut' si manquant
    ensure_students_statut(db_files["students"])

    print("\nTerminé.")
