# qr_scanner.py
import cv2
from pyzbar import pyzbar
from datetime import datetime
from db_manager import log_access

def scan_qr_camera(type_: str = "student", source: str = "camera"):
    """
    Scanner QR Code depuis caméra en temps réel.
    type_: student/family/nutrition
    source: camera, POS, autre
    """
    cap = cv2.VideoCapture(0)
    if not cap.isOpened():
        print("Impossible d'ouvrir la caméra")
        return

    print("Appuyez sur 'q' pour quitter")
    scanned = set()

    while True:
        ret, frame = cap.read()
        if not ret:
            continue

        qrcodes = pyzbar.decode(frame)
        for qr in qrcodes:
            qr_data = qr.data.decode("utf-8")
            if qr_data not in scanned:
                scanned.add(qr_data)
                print(f"QR Code détecté: {qr_data}")
                log_access(qr_data, type_, source)

        cv2.imshow("Scanner QR Code", frame)
        if cv2.waitKey(1) & 0xFF == ord("q"):
            break

    cap.release()
    cv2.destroyAllWindows()

def scan_qr_image(image_path: str, type_: str = "student", source: str = "POS"):
    """
    Scanner QR Code depuis une image (POS ou fichier)
    """
    img = cv2.imread(image_path)
    if img is None:
        print(f"Impossible de lire l'image {image_path}")
        return

    qrcodes = pyzbar.decode(img)
    for qr in qrcodes:
        qr_data = qr.data.decode("utf-8")
        print(f"QR Code détecté: {qr_data}")
        log_access(qr_data, type_, source)

if __name__ == "__main__":
    # Exemple pour caméra
    scan_qr_camera(type_="student", source="camera")

    # Exemple pour image POS
    # scan_qr_image("pos_qr.png", type_="family", source="POS")
