# pdf_manager.py
import os
from reportlab.pdfgen import canvas
from reportlab.lib.pagesizes import A4
from reportlab.lib.utils import ImageReader

RESOURCES_DIR = os.path.join(os.getcwd(), "resources")
LOGO_PATH = os.path.join(RESOURCES_DIR, "logo.png")

def generate_pdf(data: dict, output_path: str):
    """
    Génère un PDF fiche complète pour student/family/nutrition
    """
    c = canvas.Canvas(output_path, pagesize=A4)
    width, height = A4

    # Logo
    if os.path.exists(LOGO_PATH):
        logo = ImageReader(LOGO_PATH)
        c.drawImage(logo, 40, height - 100, width=80, preserveAspectRatio=True, mask='auto')

    # Titre
    c.setFont("Helvetica-Bold", 20)
    c.drawString(150, height - 60, "FICHE D'INFORMATION")

    # Informations
    c.setFont("Helvetica", 12)
    y = height - 120
    line_height = 20

    for key, value in data.items():
        if key == "photo_path":
            # Photo de l'utilisateur
            if value and os.path.exists(value):
                user_img = ImageReader(value)
                c.drawImage(user_img, width - 150, y - 50, width=100, height=100, mask='auto')
            continue
        c.drawString(50, y, f"{key}: {value}")
        y -= line_height

    c.showPage()
    c.save()
