# init_users_db.py
import sqlite3
import os

os.makedirs("database", exist_ok=True)

conn = sqlite3.connect("database/users.db")
c = conn.cursor()

# Création de la table users
c.execute("""
CREATE TABLE IF NOT EXISTS users (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    username TEXT UNIQUE NOT NULL,
    password TEXT NOT NULL,
    role TEXT NOT NULL
)
""")

# Ajout d’un compte admin par défaut
try:
    c.execute("INSERT INTO users (username, password, role) VALUES (?, ?, ?)", ("admin", "admin", "admin"))
    print("✅ Compte admin créé : utilisateur='admin', mot de passe='admin'")
except sqlite3.IntegrityError:
    print("ℹ️ Compte admin déjà existant.")

conn.commit()
conn.close()
