# gui/utils.py
import os
import sqlite3
import hashlib

# -------------------------
# Hash des mots de passe
# -------------------------
def hash_password(password: str) -> str:
    """Retourne un hash sécurisé pour un mot de passe"""
    salt = "DLOGI2025salt"  # tu peux générer un salt unique par utilisateur si besoin
    return hashlib.sha256((password + salt).encode("utf-8")).hexdigest()

def check_password(password: str, hashed: str) -> bool:
    """Vérifie si le mot de passe correspond au hash"""
    return hash_password(password) == hashed

# -------------------------
# Initialisation DB utilisateurs
# -------------------------
def init_users_db(db_path: str):
    """Crée la table users si inexistante et ajoute un admin par défaut"""
    conn = sqlite3.connect(db_path)
    c = conn.cursor()
    c.execute("""
        CREATE TABLE IF NOT EXISTS users (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            username TEXT UNIQUE,
            password TEXT
        )
    """)
    # Ajouter un admin par défaut si inexistant
    c.execute("SELECT * FROM users WHERE username = 'admin'")
    if not c.fetchone():
        hashed_pwd = hash_password("1234")
        c.execute("INSERT INTO users (username, password) VALUES (?, ?)", ("admin", hashed_pwd))
    conn.commit()
    conn.close()

# -------------------------
# Création des dossiers nécessaires
# -------------------------
def create_directories(base_dir=None):
    """Crée automatiquement les dossiers pour l'application"""
    if base_dir is None:
        base_dir = os.getcwd()
    folders = ["cards", "pdfs", "photos", "database", "resources"]
    for folder in folders:
        path = os.path.join(base_dir, folder)
        os.makedirs(path, exist_ok=True)
