# gui/lists.py
from PyQt6.QtWidgets import QWidget, QVBoxLayout, QLabel, QLineEdit, QListWidget
from db_manager import search_students, search_families, search_nutrition

class StudentList(QWidget):
    def __init__(self):
        super().__init__()
        layout = QVBoxLayout()
        self.search = QLineEdit(); self.search.setPlaceholderText("Rechercher étudiant...")
        self.list_widget = QListWidget()
        self.search.textChanged.connect(self.update_list)
        layout.addWidget(self.search)
        layout.addWidget(self.list_widget)
        self.setLayout(layout)

    def update_list(self):
        query = self.search.text()
        self.list_widget.clear()
        for s in search_students(query):
            self.list_widget.addItem(f"{s[0]} - {s[1]} {s[2]} {s[3]} | {s[4]} | {s[5]}")

class FamilyList(QWidget):
    def __init__(self):
        super().__init__()
        layout = QVBoxLayout()
        self.search = QLineEdit(); self.search.setPlaceholderText("Rechercher famille...")
        self.list_widget = QListWidget()
        self.search.textChanged.connect(self.update_list)
        layout.addWidget(self.search)
        layout.addWidget(self.list_widget)
        self.setLayout(layout)

    def update_list(self):
        query = self.search.text()
        self.list_widget.clear()
        for f in search_families(query):
            self.list_widget.addItem(f"{f[0]} - {f[1]} | Responsable: {f[2]}")

class NutritionList(QWidget):
    def __init__(self):
        super().__init__()
        layout = QVBoxLayout()
        self.search = QLineEdit(); self.search.setPlaceholderText("Rechercher nutrition...")
        self.list_widget = QListWidget()
        self.search.textChanged.connect(self.update_list)
        layout.addWidget(self.search)
        layout.addWidget(self.list_widget)
        self.setLayout(layout)

    def update_list(self):
        query = self.search.text()
        self.list_widget.clear()
        for n in search_nutrition(query):
            self.list_widget.addItem(f"{n[0]} - {n[1]} | Dossier: {n[2]}")
