# gui/forms.py
import os
from PyQt6.QtWidgets import (
    QWidget, QVBoxLayout, QHBoxLayout, QLabel, QLineEdit, QPushButton, QFileDialog, QMessageBox, QComboBox, QSpinBox
)
from db_manager import insert_student, insert_family, insert_nutrition
from excel_import import import_excel
from id_card import generate_id_card
from pdf_manager import generate_pdf

DB_DIR = os.path.join(os.getcwd(), "database")

class StudentForm(QWidget):
    def __init__(self):
        super().__init__()
        layout = QVBoxLayout()

        # Champs
        self.matricule = QLineEdit(); self.matricule.setPlaceholderText("Matricule")
        self.nom = QLineEdit(); self.nom.setPlaceholderText("Nom")
        self.post_nom = QLineEdit(); self.post_nom.setPlaceholderText("Post-Nom")
        self.prenom = QLineEdit(); self.prenom.setPlaceholderText("Prénom")
        self.pere = QLineEdit(); self.pere.setPlaceholderText("Nom du Père")
        self.mere = QLineEdit(); self.mere.setPlaceholderText("Nom de la Mère")
        self.naissance = QLineEdit(); self.naissance.setPlaceholderText("Naissance")
        self.sexe = QComboBox(); self.sexe.addItems(["Masculin","Féminin"])
        self.ecole = QLineEdit(); self.ecole.setPlaceholderText("Institution")
        self.classe = QLineEdit(); self.classe.setPlaceholderText("Classe")
        self.resultat = QLineEdit(); self.resultat.setPlaceholderText("Resultat")
        self.mention = QLineEdit(); self.mention.setPlaceholderText("Mention")
        self.photo_path = QLineEdit(); self.photo_path.setPlaceholderText("Chemin photo")
        self.upload_btn = QPushButton("Choisir Photo")
        self.upload_btn.clicked.connect(self.choose_photo)

        # Buttons
        self.save_btn = QPushButton("Enregistrer et Générer ID/PDF")
        self.save_btn.clicked.connect(self.save_student)
        self.import_excel_btn = QPushButton("Importer Excel et Générer")
        self.import_excel_btn.clicked.connect(lambda: import_excel(self))

        # Layout
        layout.addWidget(self.matricule); layout.addWidget(self.nom); layout.addWidget(self.post_nom)
        layout.addWidget(self.prenom); layout.addWidget(self.pere); layout.addWidget(self.mere)
        layout.addWidget(self.naissance); layout.addWidget(QLabel("Sexe")); layout.addWidget(self.sexe)
        layout.addWidget(self.ecole); layout.addWidget(self.classe)
        layout.addWidget(self.resultat); layout.addWidget(self.mention)
        layout.addWidget(self.photo_path); layout.addWidget(self.upload_btn)
        layout.addWidget(self.save_btn); layout.addWidget(self.import_excel_btn)
        self.setLayout(layout)

    def choose_photo(self):
        path, _ = QFileDialog.getOpenFileName(self, "Choisir photo", "", "Images (*.png *.jpg *.jpeg)")
        if path:
            self.photo_path.setText(path)

    def save_student(self):
        data = {
            "matricule": self.matricule.text(),
            "nom": self.nom.text(),
            "post_nom": self.post_nom.text(),
            "prenom": self.prenom.text(),
            "pere": self.pere.text(),
            "mere": self.mere.text(),
            "naissance": self.naissance.text(),
            "sexe": self.sexe.currentText(),
            "ecole": self.ecole.text(),
            "classe": self.classe.text(),
            "resultat": self.resultat.text(),
            "mention": self.mention.text(),
            "photo_path": self.photo_path.text()
        }
        try:
            insert_student(data)
            QMessageBox.information(self, "Succès", "Etudiant enregistré")
            # Générer ID et PDF
            id_path = os.path.join(DB_DIR, f"{data['matricule']}_IDCARD.png")
            pdf_path = os.path.join(DB_DIR, f"{data['matricule']}_FICHE.pdf")
            generate_id_card(data, id_path)
            generate_pdf(data, pdf_path)
        except Exception as e:
            QMessageBox.warning(self, "Erreur", str(e))


class FamilyForm(QWidget):
    def __init__(self):
        super().__init__()
        layout = QVBoxLayout()
        self.matricule = QLineEdit(); self.matricule.setPlaceholderText("Matricule")
        self.nom_famille = QLineEdit(); self.nom_famille.setPlaceholderText("Nom Famille")
        self.responsable = QLineEdit(); self.responsable.setPlaceholderText("Responsable")
        self.adresse = QLineEdit(); self.adresse.setPlaceholderText("Adresse")
        self.zone = QLineEdit(); self.zone.setPlaceholderText("Zone")
        self.nb_enfant = QSpinBox(); self.nb_enfant.setRange(0, 20)
        self.categorie = QLineEdit(); self.categorie.setPlaceholderText("Categorie")
        self.debut = QLineEdit(); self.debut.setPlaceholderText("Debut")
        self.fin = QLineEdit(); self.fin.setPlaceholderText("Fin")
        self.photo_path = QLineEdit(); self.photo_path.setPlaceholderText("Chemin photo")
        self.upload_btn = QPushButton("Choisir Photo"); self.upload_btn.clicked.connect(self.choose_photo)
        self.save_btn = QPushButton("Enregistrer"); self.save_btn.clicked.connect(self.save_family)

        layout.addWidget(self.matricule); layout.addWidget(self.nom_famille)
        layout.addWidget(self.responsable); layout.addWidget(self.adresse)
        layout.addWidget(self.zone); layout.addWidget(QLabel("Nombre Enfant")); layout.addWidget(self.nb_enfant)
        layout.addWidget(self.categorie); layout.addWidget(self.debut); layout.addWidget(self.fin)
        layout.addWidget(self.photo_path); layout.addWidget(self.upload_btn)
        layout.addWidget(self.save_btn)
        self.setLayout(layout)

    def choose_photo(self):
        path, _ = QFileDialog.getOpenFileName(self, "Choisir photo", "", "Images (*.png *.jpg *.jpeg)")
        if path:
            self.photo_path.setText(path)

    def save_family(self):
        data = {
            "matricule": self.matricule.text(),
            "nom_famille": self.nom_famille.text(),
            "responsable": self.responsable.text(),
            "adresse": self.adresse.text(),
            "zone": self.zone.text(),
            "nb_enfant": self.nb_enfant.value(),
            "categorie": self.categorie.text(),
            "debut": self.debut.text(),
            "fin": self.fin.text(),
            "photo_path": self.photo_path.text()
        }
        try:
            insert_family(data)
            QMessageBox.information(self, "Succès", "Famille enregistrée")
        except Exception as e:
            QMessageBox.warning(self, "Erreur", str(e))


class NutritionForm(QWidget):
    def __init__(self):
        super().__init__()
        layout = QVBoxLayout()
        self.matricule = QLineEdit(); self.matricule.setPlaceholderText("Matricule")
        self.nom = QLineEdit(); self.nom.setPlaceholderText("Nom")
        self.parent = QLineEdit(); self.parent.setPlaceholderText("Parent")
        self.adresse = QLineEdit(); self.adresse.setPlaceholderText("Adresse")
        self.dossier_no = QLineEdit(); self.dossier_no.setPlaceholderText("No Dossier")
        self.poids = QLineEdit(); self.poids.setPlaceholderText("Poids")
        self.taille = QLineEdit(); self.taille.setPlaceholderText("Taille")
        self.signes = QLineEdit(); self.signes.setPlaceholderText("Signes")
        self.date_enregistrement = QLineEdit(); self.date_enregistrement.setPlaceholderText("Date")
        self.photo_path = QLineEdit(); self.photo_path.setPlaceholderText("Chemin photo")
        self.upload_btn = QPushButton("Choisir Photo"); self.upload_btn.clicked.connect(self.choose_photo)
        self.save_btn = QPushButton("Enregistrer"); self.save_btn.clicked.connect(self.save_nutrition)

        layout.addWidget(self.matricule); layout.addWidget(self.nom); layout.addWidget(self.parent)
        layout.addWidget(self.adresse); layout.addWidget(self.dossier_no); layout.addWidget(self.poids)
        layout.addWidget(self.taille); layout.addWidget(self.signes); layout.addWidget(self.date_enregistrement)
        layout.addWidget(self.photo_path); layout.addWidget(self.upload_btn); layout.addWidget(self.save_btn)
        self.setLayout(layout)

    def choose_photo(self):
        path, _ = QFileDialog.getOpenFileName(self, "Choisir photo", "", "Images (*.png *.jpg *.jpeg)")
        if path:
            self.photo_path.setText(path)

    def save_nutrition(self):
        data = {
            "matricule": self.matricule.text(),
            "nom": self.nom.text(),
            "parent": self.parent.text(),
            "adresse": self.adresse.text(),
            "dossier_no": self.dossier_no.text(),
            "poids": float(self.poids.text() or 0),
            "taille": float(self.taille.text() or 0),
            "signes": self.signes.text(),
            "date_enregistrement": self.date_enregistrement.text(),
            "photo_path": self.photo_path.text()
        }
        try:
            insert_nutrition(data)
            QMessageBox.information(self, "Succès", "Nutrition enregistrée")
        except Exception as e:
            QMessageBox.warning(self, "Erreur", str(e))
