<?php
session_start();

// Empêcher accès si non connecté
if (!isset($_SESSION['user'])) {
    header("Location: login.php");
    exit;
}

// CONFIG DB
$host = "localhost";
$user = "root";
$pass = "";
$db   = "smartidtech";

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die("Erreur connexion DB : " . $conn->connect_error);
}

// Initialisation
$message = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $old_password = trim($_POST["old_password"]);
    $new_password = trim($_POST["new_password"]);
    $confirm_password = trim($_POST["confirm_password"]);

    $email = $_SESSION['user']['email'];

    // Récupération de l'utilisateur
    $sql = "SELECT * FROM users WHERE email = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();

    // Vérifier ancien mot de passe
    if (!password_verify($old_password, $user['password'])) {
        $message = "<p style='color:red;'>⚠ Ancien mot de passe incorrect !</p>";
    }
    // Vérifier confirmation
    elseif ($new_password !== $confirm_password) {
        $message = "<p style='color:red;'>⚠ Les mots de passe ne correspondent pas.</p>";
    }
    // Vérifier force du mot de passe
    elseif (strlen($new_password) < 6) {
        $message = "<p style='color:red;'>⚠ Le nouveau mot de passe doit contenir au moins 6 caractères.</p>";
    }
    else {
        // Hashage du nouveau mot de passe
        $hashed = password_hash($new_password, PASSWORD_DEFAULT);

        // Mise à jour DB
        $sql_update = "UPDATE users SET password = ? WHERE email = ?";
        $stmt2 = $conn->prepare($sql_update);
        $stmt2->bind_param("ss", $hashed, $email);

        if ($stmt2->execute()) {
            $message = "<p style='color:green;'>✔ Mot de passe modifié avec succès !</p>";
        } else {
            $message = "<p style='color:red;'>❌ Erreur lors de la mise à jour.</p>";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Modifier le mot de passe</title>
    <style>
        body {
            background: #f2f2f2;
            font-family: Arial, sans-serif;
        }
        .box {
            width: 350px;
            margin: 80px auto;
            padding: 25px;
            background: white;
            border-radius: 8px;
            box-shadow: 0 0 10px #ccc;
        }
        input {
            width: 100%;
            padding: 10px;
            margin: 6px 0;
        }
        button {
            background: #007BFF;
            color: white;
            width: 100%;
            padding: 10px;
            margin-top: 8px;
            border: none;
            cursor: pointer;
        }
        button:hover {
            background: #0056d2;
        }
        a {
            display: block;
            margin-top: 10px;
            text-align:center;
        }
    </style>
</head>
<body>

<div class="box">
    <h2>Changer votre mot de passe</h2>

    <?= $message ?>

    <form method="POST">
        <label>Ancien mot de passe</label>
        <input type="password" name="old_password" required>

        <label>Nouveau mot de passe</label>
        <input type="password" name="new_password" required>

        <label>Confirmer le mot de passe</label>
        <input type="password" name="confirm_password" required>

        <button type="submit">Modifier</button>
    </form>

    <a href="user_dashboard.php">⬅ Retour</a>
</div>

</body>
</html>
