import sys
import traceback
from PyQt6.QtWidgets import QApplication, QMessageBox

# --------------------------
# Gestionnaire global d'erreurs
# --------------------------
def global_exception_hook(exctype, value, tb):
    """Capture toutes les exceptions non gérées"""
    err_msg = "".join(traceback.format_exception(exctype, value, tb))
    print("Erreur capturée :", err_msg)  # affichage console
    with open("logs.txt", "a", encoding="utf-8") as f:
        f.write(err_msg + "\n" + "="*50 + "\n")
    
    # Afficher une boîte d'erreur PyQt
    try:
        QMessageBox.critical(None, "Erreur Critique", f"Une erreur est survenue :\n{value}")
    except Exception:
        pass  # si PyQt est déjà KO, on ignore

# --------------------------
# Wrapper pour lancer l'application
# --------------------------
def run_app(main_class, *args, **kwargs):
    """
    main_class : la classe principale de l'application PyQt
    *args, **kwargs : arguments pour le constructeur de la classe principale
    """
    sys.excepthook = global_exception_hook  # installer le hook global
    app = QApplication(sys.argv)
    try:
        w = main_class(*args, **kwargs)
        w.show()
        sys.exit(app.exec())
    except Exception as e:
        global_exception_hook(type(e), e, e.__traceback__)
